import 'package:flutter/material.dart';
import 'package:razinsoft_rider/data/models/ride_service_response.dart';
import 'package:razinsoft_rider/data/services/navigation_service.dart';

import '../../../core/routes/app_routes.dart';
import '../../../data/models/car_type_state.dart';
import '../viewmodel/car_type_notifier.dart';
import 'car_type_card.dart';

Widget carGridView({required List<Services> list, required CarTypeNotifier notifier, required CarTypeState state})=> Expanded(
    child: ListView.builder(
      itemCount: list.length,
      scrollDirection: Axis.horizontal,
      itemBuilder: (context, index) {
        final type = list[index];
        final isSelected = state.selectedCarType == type;
        return buildCarCard(type, isSelected, notifier, context, onTap: () {
          notifier.selectCar(type, resetSelectedLocationState: true);
          Future.delayed(Duration.zero).then((_){
            WidgetsBinding.instance.addPostFrameCallback((_) {
              NavigationService.pushNamed(AppRoutes.searchDestinationPage);
            });
          });

        });
      },
    ),
  );